export interface OfferingInfo {
    "aid": string,
    "oid": string,
    "model": string,
    "title": string,
    "price": string,
}

export class PTCatalogueService {
    private baseURL: string
    private token: string | undefined;
    constructor(baseURL: string, token: string | undefined) {
        this.baseURL = baseURL
        this.token = token
    }


    async getAssetOfferings(assetIds: string[]): Promise<OfferingInfo[]> {
        const body = {
            ids: assetIds
        }
        const url = `${this.baseURL}/v1.0/offerings`
        const headers: { [k: string]: string } = {
            "Content-Type": "application/json"
        }
        if (this.token) headers.Authorization = this.token

        const response = await fetch(url, { method: "PUT", headers, body: JSON.stringify(body) })
        if (response.status !== 200) {
            console.error(`Failed to obtain asset offerings, status code: ${response.status}`)
            return []
        }
        return response.json()
    }
}